//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.10 Page 152
//Title: Water flowing in an orifice meter
//===================================================================

model Ex5_10 

//=============
// Parameter Section 

parameter Real v1(unit = "m/s") = 1 "Velocity of water in the pipe";
parameter Real rho_water(unit = "kg/m3") = 998.2 "Density of water";
parameter Real d_1(unit = "m") = 0.4 "Diameter of pipe";
parameter Real d_2(unit = "m") = 0.2 "Diameter of hole";
parameter Real cv(unit = "NA") =0.62 "Discharge coefficient";
parameter Real c1(unit = "Pa/kPa") = 1000 "Conversion factor";

//===============
// Library Section 

extends Modelica.Constants;

//=============
// Variable Section 

Real v2(unit = "m/s") "Velocity of water in the hole ";
Real p_d(unit = "kPa") "Pressure difference between pipe and hole";

//=============
// Equation Section 

equation
v2 = v1 * ((pi * d_1^2 / 4) / (pi * d_2^2 / 4));
p_d = ( rho_water * v2^2 * (1 - (((pi * d_2^2 / 4) / (pi * d_1^2 / 4)))^4) / ( 2 * cv^2) ) / c1;
end Ex5_10;