//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.4 Page 144
//Title: Flow out of Nozzle
//===================================================================

model Ex5_4

//=============
// Parameter Section 

parameter Real h(unit = "ft") = 30 "Height of the tank from the nozzle";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real a2(unit = "ft2") = 1 "Area of outlet nozzle";
parameter Real a1(unit = "ft2") = 4 "Crossectional area of the tank";

//=============
// Variable Section 

Real v(unit = "ft/s") "Fluid velocity at the nozzle";

//=============
// Equation Section

equation
v = (2 * g * h / ( 1 - (a2 / a1)^2))^0.5;

end Ex5_4;