//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.6 Page 147
//Title: Pitot Tube
//===================================================================

model Ex5_6

//=============
// Parameter Section 

parameter Real h(unit = "m") = 1 "Height of the fluid from the surface";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";

//=============
// Variable Section 

Real v(unit = "m/s") "Fluid velocity in the nozzle";

//=============
// Equation Section

equation
v = (2* g* h)^(0.5); 
end Ex5_6;