//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.11 Page 203
//Title: Fitting Losses
//===================================================================

model Ex6_11

//=============
// Parameter Section

parameter Real f(unit = "NA") = 0.0091 "Friction factor of the pipe";
parameter Real l(unit = "ft") = 3000 "Length of the pipe";
parameter Real D(unit = "in") = 3.068 "Diameter of the pipe";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of the water";
parameter Real v(unit = "ft/s") = 13 "Velocity of the water";
parameter Real ld_1(unit = "NA") = 350 "Equivalent length of the globe valves";
parameter Real n_1(unit = "NA") = 2 "Number of globe valves";
parameter Real ld_2(unit = "NA") = 110 "Equivalent length of the swing check valves";
parameter Real n_2(unit = "NA") = 1 "Number of swing check valves";
parameter Real ld_3(unit = "NA") = 32 "Equivalent length of the standard elbows";
parameter Real n_3(unit = "NA") = 9 "Number of standard elbows";
parameter Real c1(unit = "in/ft") = 12 "Conversion factor";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c3(unit = "in2/ft2") = 144 "Conversion factor";

//=============
// Variable Section

Real l_d(unit = "ft") "Equivalent length for fittings";
Real a_l(unit = "ft") "Adjusted length of the pipe";
Real delp(unit = "psi") "Pressure drop in the pipe";
Real delp_t(unit = "psi") "Total pressure drop in the pipe incl valves and fittings";
Real delp_v(unit = "psi") "Pressure drop of valves and fittings";

//=============
// Equation Section

equation

delp = 4 * f * l * rho * v^2 / ( ( D / c1 ) * 2 * c2 * c3);
l_d = (n_1 * ld_1 + n_2 * ld_2 + n_3 * ld_3) * ( D / c1 );
a_l = l + l_d;
delp_t = delp * (a_l / l);
delp_v = delp_t - delp;

end Ex6_11;