//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.12 Page 203
//Title: Fitting Losses
//===================================================================

model Ex6_12

//=============
// Parameter Section

parameter Real n_1(unit = "NA") = 3 "Number of globe valves";
parameter Real n_2(unit = "NA") = 1 "Number of swing check valves";
parameter Real n_3(unit = "NA") = 9 "Number of standard elbows";
parameter Real k_1(unit = "NA") = 6.3 "K value of globe valves";
parameter Real k_2(unit = "NA") = 2 "K value of swing check valves";
parameter Real k_3(unit = "NA") = 0.74 "K value of standard elbows";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of the water";
parameter Real v(unit = "ft/s") = 13 "Velocity of the water";
parameter Real c1(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c2(unit = "in2/ft2") = 144 "Conversion factor";

//=============
// Variable Section

Real k_sum(unit = "NA") "Summation of k value";
Real delp(unit = "psi") "Pressure drop of valves and fittings";

//=============
// Equation Section

equation
k_sum = ( n_1*k_1 + n_2*k_2 + n_3*k_3);
delp = k_sum * rho * v^2 / (2 * c1 * c2);

end Ex6_12;