//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.17 Page 212
//Title: Complex problems involving Bernoulli Equation
//===================================================================

model Ex6_17

//=============
// Parameter Section

parameter Real delp(unit = "lbf/in2") = 5.65 "Pressure difference in the hose";
parameter Real delx(unit = "ft") = 100 "Height difference between the river and the nozzle";
parameter Real l(unit = "ft") = 300 "Total length of the hose";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of water";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real v(unit = "ft/s") = 100 "Velocity of water";
parameter Real V(unit = "gal/min") = 500 "Volumetric flowrate of water";
parameter Real c1(unit = "lbm/gal") = 8.33 "Conversion factor";
parameter Real c2(unit = "s/min") = 60 "Conversion factor";
parameter Real c3(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor"; 
parameter Real c4(unit = "ft.lbf/hp.s") = 550 "Conversion factor"; 
parameter Real c5(unit = "in2/ft2") = 144 "Conversion factor";

//=============
// Variable Section

Real f(unit = "ft2/s2") "Friction loss term";
Real dW(unit = "ft2/s2") "Work done by pump";
Real m(unit = "lbm/s") "Mass flowrate of water";
Real Po(unit = "hp") "Power required of the pump";

//=============
// Equation Section

equation 

f = delp * l * c3 * c5 / (delx * rho);
dW = g * delx + (v^2/2) + f;
m = V * c1 / c2;
Po = dW * m / (c3 * c4);



end Ex6_17;