//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.18 Page 217
//Title: Economic Pipe Diameter, Economic Velocity
//===================================================================

model Ex6_18

//=============
// Parameter Section

parameter Real V(unit = "lbm/min") = 200 "Volumetric flowrate of water";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of water";
parameter Real E_D(unit = "NA") = 6 * 10^(-4) "Roughness factor per unit length";
parameter Real f(unit = "NA") = 4.2 * 10 ^(-3) "Friction factor of the pipe";
parameter Real PC(unit = "$/kWh")= 0.04 "Pumping charge";
parameter Real PP(unit = "$/in of diameter.ft of length") = 2 "Purchase price";
parameter Real CC(unit = "1/yr") = 0.4 "Construction costs";
parameter Real c1(unit = "lbm/gal") = 8.33 "Conversion factor";
parameter Real c2(unit = "kJ/kW.h") = 3600 "Conversion factor";
parameter Real c3(unit = "ft.lbf/kJ") = 737.6 "Conversion factor";
parameter Real c4(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c5(unit = "s2/min2") = 3600 "Conversion factor";
parameter Real c6(unit = "min/yr") = 5.256 * 10^5 "Conversion factor";
parameter Real c7(unit = "in/ft") = 12 "Conversion factor";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real m(unit = "lbm/min") "Mass flowrate of water";
Real D_econ(unit = "ft") "Economic pipe diameter";

//=============
// Equation Section

equation

m = V * c1;
D_econ = ((10 * PC * m^3 * f * (4/pi)^2 * (1/rho^2) / (CC * PP) ) * ( c6 / ( c2 * c3 * c4 * c5 * c7)))^(1/6);
end Ex6_18;