//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.2 Page 182
//Title: Fluid Friction in Steady, One Dimensional
//===================================================================

model Ex6_2

//=============
// Parameter Section 

parameter Real rho(unit = "kg/m3") = 1050 "Density of the fluid";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real del_z(unit = "m") = 0.12 "Height difference between points 1 and 2";
parameter Real D(unit = "m") = 0.001 "Inner diameter of the tube";
parameter Real Q(unit = "m3/s") = 10^(-8) "Flow rate of the fluid";
parameter Real del_x(unit = "m") = 0.1 "Height of the tube";
parameter Real c1(unit = "cP.m.s/kg") = 10^3 "Conversion factor";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real u(unit = "cP") "Viscosity of the fluid";

//=============
// Equation Section

equation

u = (rho * g * del_z * pi * D^4 * c1) / (128 * Q * del_x);

   
end Ex6_2;