//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.21 Page 226
//Title: Flow around Submerged Objects
//===================================================================

model Ex6_21

//=============
// Parameter Section

parameter Real d(unit = "ft") = 5 "Diameter of the cylindrical chimney";
parameter Real v(unit = "mi/h") = 20 "Velocity of the wind";
parameter Real rho(unit = "lbm/ft3") = 0.075 "Density of air";
parameter Real u(unit = "cP") = 0.018 "Viscosity of air";
parameter Real c1(unit = "ft/mi") = 5280 "Conversion factor";
parameter Real c2(unit = "s/h") = 3600 "Conversion factor";
parameter Real c3(unit = "lbm/cP.s.ft") = 6.72 * 10^(-4) "Conversion factor";
parameter Real A(unit = "ft2/ft") = 5 "Crossectional area of the chimney";
parameter Real Cd(unit = "NA") = 0.35 "Drag coefficient";
parameter Real c4(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Variable Section

Real R(unit = "NA") "Reynolds number";
Real F(unit = "lbf/ft") "Wind force per foot";

//=============
// Equation Section

equation

R = (d * v * rho * c1) / (u * c2 * c3);
F = (A * Cd * rho * v^2 * c1^2) / (2 * c2^2 * c4);


end Ex6_21;