//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.8 Page 197
//Title: More Convenient Methods
//===================================================================

model Ex6_8

//=============
// Parameter Section

parameter Real l(unit = "ft") = 2000 "Length of the pipe";
parameter Real v(unit = "gal/min") = 200 "Volumetric flowrate of the water";
parameter Real delp(unit = "psi/ft") = 3.87 * 10^(-2) "Pressure drop in the pipe per feet";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of the water";
parameter Real c1(unit = "gal/ft3") = 7.48 "Conversion factor";
parameter Real c2(unit = "s/min") = 60 "Conversion factor";
parameter Real c3(unit = "in2/ft2") = 144 "Conversion factor";
parameter Real c4(unit = "ft.lbf/hp.s") = 550 "Conversion factor";

//=============
// Variable Section

Real m(unit = "lbm/s") "Mass flowrate of the water";
Real Po(unit = "hp") "Pump power required";

//=============
// Equation Section

equation

m = v * rho / (c1 * c2);
Po = (delp * l) * m * c3 / (rho * c4);
end Ex6_8;