//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.10 Page 259
//Title: Air flowrate of Exhaust gas from Jet Engine
//===================================================================

model Ex7_10

//=============
// Parameter Section

parameter Real F(unit = "lbf") = 20000 "Thrust produced by the engine";
parameter Real V_in(unit = "ft/s") = 0 "Inlet velocity of exahaust gas"; 
parameter Real V_out(unit = "ft/s") = 1350 "Outlet velocity of exahaust gas";
parameter Real c(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor for lbf to lbm";

//=============
// Variable Section

Real m_air(unit = "lbm/s") "Mass flowrate of the exhaust gas"; 

//=============
// Equation Section

equation
m_air = (- F / (V_in - V_out) )*c;
end Ex7_10;