//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.12 Page 267
//Title: Final Velocity of Rocket given Specific Impulse
//===================================================================

model Ex7_12

//=============
// Parameter Section

parameter Real V_in(unit = "ft/s") = 0 "Initial velocity of the rocket";
parameter Real m(unit = "NA") = 0.1 "Ratio of final and initial mass flowrates";
parameter Real I(unit = "lbf.s/lbm") = 430 "Specific Impulse of the fuel";
parameter Real c(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor for lbf to lbm";

extends Modelica.Math;


//=============
// Variable Section

Real V_rel(unit = "ft/s") "Relative velocity of the fuel wrt system";
Real V_fin(unit = "ft/s") "Final velocity of the rocket";

//=============
// Equation Section

equation
V_rel = - I * c;
V_fin = V_rel * log(m);

end Ex7_12;