//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.15 Page 278
//Title: Froude number
//===================================================================

model Ex7_15

//=============
// Parameter Section

parameter Real v_1(unit = "ft/s") = 4 "Velocity of the inlet";
parameter Real z_1(unit = "ft") = 0.0005 "Height of the pipe inlet";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";

//=============
// Library Section
extends Modelica.Math;

//=============
// Variable Section

Real Fr(unit = "NA") "Froude number";
Real z_2(unit = "ft") "Height of the pipe outlet";
Real v_2(unit = "ft/s") "Velocity of the pipe outlet";

//=============
// Equation Section

equation
Fr = v_1^2/(g*z_1);
z_2 = z_1 * ( -0.5 + sqrt(0.25 + (2* v_1^2/(g * z_1))));
v_2 = (v_1 * z_1)/z_2;
end Ex7_15;