//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.18 Page 284
//Title: Angular Momentum Balance
//===================================================================

model Ex7_18

//=============
// Parameter Section

parameter Real omega(unit = "rev/min") = 1800 "Tangential Velocity";
parameter Real m_gal(unit = "gal/min") = 100 "Mass flowrate of water in gallon";
parameter Real r_in(unit = "in") = 1 "Inner radius";
parameter Real r_out(unit = "in") = 6 "Outer Radius";
parameter Real c1(unit = "lbm/gal") = 8.33 "Conversion factor for gallons to lbm";
parameter Real c2(unit = "lbm.ft.lbf.s2") = 32.2 "Conversion factor";
parameter Real c3(unit = "s2/min2") = 3600 " Conversion factor for second to minute";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real m(unit = "lbm/min") "Mass flowrate of water";
Real tau(unit = "ft.lbf") "Torque exerted on the rotor";

//=============
// Equation Section

equation

m = m_gal * c1;
tau = m * 2 * pi * omega * ((r_out/(2 * r_out))^2 - (r_in/(2 * r_out))^2) * (1/c2) * (1/c3);
end Ex7_18;