//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7. Page 258
//Title: Force of Exhaust gas from the Rocket 
//===================================================================

model Ex7_8

//=============
// Parameter Section

parameter Real m(unit = "kg/s") = 1000 "Mass flowrate of the exhaust gas";
parameter Real v(unit = "m/s") = 3000 "Velocity of the exhaust gas"; 
                                     //Sign convention for negative y direction
parameter Real a(unit = "m2") = 7 "Exit area of the nozzle";
parameter Real p(unit = "kPa") = 35 "Pressure at the exit area of the nozzle";

//=============
// Variable Section  

Real F(unit = "N") "Thrust of the rocket";

//=============
// Equation Section

equation
F = - ( -v * m ) + ( a * p * 1000); //Conversion from kPa to Pa
 
end Ex7_8;