//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-8: One Dimensional, High Velocity Gas Flow
//Example: 8.12 Page 324
//Title: Relative Velocities, Changing Reservoir Conditions
//===================================================================

model Ex8_12

//=============
// Parameter Section

parameter Real M(unit = "NA") = 2 "Mach number";
parameter Real T(unit = "K") = 273.15 "Temperature of the airplane";
parameter Real P(unit = "kPa") = 50 "Pressure of the airplane";
parameter Real k(unit = "NA") = 1.4 "k value of the system";

//=============
// Variable Section

Real Tr_T(unit = "NA") "Temperature ratio";
Real Tr(unit = "K") "Temperature in the reservoir";
Real Pr(unit = "kPa") "Pressure in the reservoir";

//=============
// Equation Section

equation
Tr_T = M^2 * (k-1) / 2  + 1;
Tr = Tr_T * T;
Pr = P * Tr_T^(k /(k-1));
  
end Ex8_12;