//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-1: Introduction
//Example: 1.1 Page 06
//Title: Density of mud
//===================================================================

model Ex1_1

//=============
// Parameter Section 

parameter Real rho_sand(unit = "lbm/ft3") = 165 "Density of the sand";
parameter Real rho_water(unit = "lbm/ft3") = 62.3 "Density of the water";
parameter Real m_sand(unit = "lbm sand/lbm mud") = 70 "Percentage of sand in the mud";
parameter Real m_water(unit = "lbm water/lbm mud") = 30 "Percentage of water in the mud";

//=============
// Variable Section 

Real rho_mud(unit = "lbm/ft3") "Density of the mud";

//=============
// Equation Section 

equation

// Assuming basis to be 100 lbm of mud
rho_mud = (m_sand + m_water)/((m_sand/rho_sand)+(m_water/rho_water)); 

end Ex1_1;
//===================================================================

