//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-1: Introduction
//Example: 1.2 Page 08
//Title: Shear Stress in a Couette Viscometer
//===================================================================

model Ex1_2

//=============
// Parameter Section 

parameter Real d_inner(unit = "mm") = 25.15 "Inner diameter of the cylinder";
parameter Real d_outer(unit = "mm") = 27.62 "Outer diameter of the cylinder";
parameter Real length(unit = "mm")  = 92.27 "Length of the cylinder";
parameter Real rpm(unit = "min-1")  = 10 "Rotations per minute";
parameter Real torque(unit = "N.mm") = 0.005 "Observed torque";
parameter Real rpm_sec(unit = "s-1") = rpm / 60 "Rotations per minute conversion to seconds";

//===============
// Library Section 

extends Modelica.Constants;

//=============
// Variable Section 

Real tau(unit = "N/mm2") "Shear stress";
Real v_gradient(unit = "s-1") "Velocity gradient of the two plates";
Real del_r(unit = "mm") "Distance between inner and outer cylinder in radial direction";

//=============
// Equation Section 

equation

del_r = (d_outer-d_inner)*0.5;
v_gradient = (pi * d_inner * rpm_sec)/del_r; 
tau = (torque/(0.5 * d_inner))/(pi * d_inner * length); 

//Velocity gradient is linearly approximated
//Shear stress at the surface of inner cylinder

end Ex1_2;
//===================================================================
