//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-11: Flow through Porous Media
//Example: 11.1 Page 401
//Title: Fluid Friction in Porous Media
//===================================================================

model Ex11_1

//=============
// Parameter Section

parameter Real D_p(unit = "in") = 0.03 "Diameter of particle";
parameter Real E(unit  = "NA") = 0.33 "Porosity of the bed";
parameter Real del_z(unit = "ft") = 1.25 "Height of the column";
parameter Real rho(unit = "lbm/ft") = 62.3 "Density of water";
parameter Real u(unit = "cP") = 1.002 "Viscosity of water";
parameter Real del_x(unit = "ft") = 1 "Height potetial between the 2 points";
parameter Real c1(unit = "lbm/ft.s.cP") = 6.72 * 10^(-4) "Conversion factor";
parameter Real c2(unit = "in/ft") = 12 "Conversion factor";
parameter Real g(unit = "ft/s") = 32.2 "Accleration due to gravity";
parameter Real D(unit = "in") = 2 "Diameter of the pipe";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real V_s(unit = "ft/s") "Superficial velocity";
Real Q(unit = "ft3/s") "Volumetric flowrate";
Real R(unit = "NA") "Reynolds number";

//=============
// Equation Section

equation
V_s = (g * del_z * (D_p/c2)^2 * E^3 * rho) / (150 * u * (1- E)^2 * del_x * c1);
Q = (D/c2)^2 * (pi/4) * V_s;
R = ( (D_p/c2) * V_s * rho )/( u * (1-E) * c1 );

end Ex11_1;