//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-13: Non Newtonian Fluid Flow in Circular Pipes
//Example: 13.5 Page 440
//Title: Bingham Plastics
//===================================================================

model Ex13_5

//=============
// Parameter Section

parameter Real T(unit = "Pa") = 3.8 "Shear stress of the fluid";
parameter Real u(unit = "Pa.s") = 0.00686 "Viscosity of the fluid";
parameter Real D(unit = "m") = 0.0206 "Diameter of the tube";
parameter Real rho(unit = "kg/m3") = 1530 "Density of the fluid";
parameter Real v_1(unit = "m/s") = 3.47 "Velocity at first experimental point";
parameter Real v_2(unit = "m/s") = 0.442 "Velocity at the second experimental point";
parameter Real delp_1(unit = "kPa/m") = 11.06 "Pressure gradient at first experimental point";
parameter Real delp_2(unit = "kPa/m") = 1.27 "Pressure gradient at second experimental point";

//=============
// Variable Section

Real He(unit = "NA") "Hedstrom number at both points";
Real R_1(unit = "NA") "Reynolds number at first point";
Real f_1(unit = "NA") "Friction factor at first point";
Real R_2(unit = "NA") "Reynolds number at second point";
Real f_2(unit = "NA") "Friction factor at second point";

//=============
// Equation Section

equation

He = ( T * D^2 * rho ) / ( u^2 );
R_1 = ( D * v_1 * rho ) / u;
f_1 = ( 2 * delp_1 * 1000 * D ) / (4 * rho * v_1^2); //1000 multipled for converting kPa to Pa
R_2 = ( D * v_2 * rho ) / u;
f_2 = ( 2 * delp_2 * 1000 * D ) / (4 * rho * v_2^2); //1000 multipled for converting kPa to Pa
end Ex13_5;