//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.4 Page 42
//Title: Pressure Depth Relations
//===================================================================

model Ex2_5

//=============
// Parameter Section

parameter Real P1(unit = "atm") = 1 "Atmospheric pressure above the sea";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real M(unit = "lbm/lbmol") = 29.9 "Molecular weight of air";
parameter Real R(unit = "lbf.ft3.°R/in2.lbmol") = 10.73 "Universal gas constant";
parameter Real T(unit = "°R") = 519 "Temperature of the gas";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion factor";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real z_1(unit = "ft") = 1000 "Height of the elevation";
parameter Real z_2(unit = "ft") = 10000 "Height of the elevation";
parameter Real z_3(unit = "ft") = 100000 "Height of the elevation";

//=============
// Library Section

extends Modelica.Math;

//=============
// Variable Section

Real P2_1(unit = "atm") "Pressure at height z_1";
Real P2_2(unit = "atm") "Pressure at height z_2";
Real P2_3(unit = "atm") "Pressure at height z_3";

//=============
// Equation Section

equation
P2_1 = P1  *( 1 - ( g * M * z_1 / (R * T * c1 * c2)));
P2_2 = P1  *( 1 - ( g * M * z_2 / (R * T * c1 * c2)));
P2_3 = P1  *( 1 - ( g * M * z_3 / (R * T * c1 * c2)));

end Ex2_5;