//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.8 Page 46
//Title: Pressure Forces on Surfaces
//===================================================================

model Ex2_8

//=============
// Parameter Section

parameter Real w(unit = "m") = 20 "Width of the rectangular gate";
parameter Real h_fin(unit = "m") = 10 "Height of the rectangular gate";
parameter Real h_int(unit = "m") = 0 "Reference of the height of the rectangular gate";
parameter Real rho(unit = "kg/m3") = 998.2 "Density of water";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";

//=============
// Variable Section

Real F_net(unit = "N.s2/kg.m") "Net Force exerted";

//=============
// Equation Section

equation
F_net = rho * g * w * 0.5 * (h_fin^2 - h_int^2);
 
end Ex2_8;