//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-3: The Balance Equation and the Mass Balance
//Example: 3.4 Page 88
//Title: Steady State Flow, One Dimensional Balance
//===================================================================

model Ex3_4

//=============
// Parameter Section 

parameter Real V(unit = "gal") = 15 "Volume of fuel pumped";
parameter Real t(unit = "min") = 2 "Time required to pump the fuel";
parameter Real D(unit = "in") = 1 "Diameter of the nozzle";
parameter Real s(unit = "NA") = 0.72 "Specific gravity of the fuel";
parameter Real c1(unit = "ft3/gal") = 0.133 "Conversion factor";
parameter Real c2(unit = "s/min") = 60 "Conversion factor";
parameter Real c3(unit  = "in2/ft2") = 144 "Conversion factor";
parameter Real rho_w(unit ="lbm/ft3") = 62.3 "Density of water";

//=============
// Library Section 

extends Modelica.Constants;

//=============
// Variable Section

Real Q(unit = "ft3/s") "Volumetric flowrate of the fuel";
Real m(unit = "lbm/s") "Mass flowrate of the fuel";
Real v_avg(unit = "ft/s") "Velocity of the fluid";

//=============
// Equation Section 

equation
Q = V * c1 / (t * c2) ;
m = Q  * s * rho_w;
v_avg = Q * c3/ ( pi * D^2 / 4 );
end Ex3_4; 