//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-4: The First Law of Thermodynamics
//Example: 4.4 Page 119
//Title: Air and Coal in a cylinder
//===================================================================

model Ex4_4

//=============
// Parameter Section 

parameter Real dQ(unit = "Btu") = 42 "Heat transferred to the surroundings";
parameter Real dV(unit = "ft3") = 1 "Increse in volume of the contents";
parameter Real p(unit = "lbf/in2") = 14.7 "Atmospheric pressure"; 
parameter Real c1(unit = "in2/ft2") = 144 "Conversion factor of square inch to square foot";
parameter Real c2(unit = "Btu/ft.lbf") = 778 " Conversion factor of (ft3.lbf) to Btu";

//=============
// Variable Section 

Real dU(unit = "Btu") "Internal Energy change";

//=============
// Equation Section 

equation
dU = - dQ - p * dV * c1 / c2;

end Ex4_4;