//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-4: The First Law of Thermodynamics
//Example: 4.5 Page 120
//Title: Steady flow water power plant
//===================================================================

model Ex4_5

//=============
// Parameter Section

parameter Real z(unit = "m") = 15 "Height of inlet with respect to the outlet";
parameter Real v1(unit = "m/s") = 3 "Velocity in the inlet";
parameter Real v2(unit = "m/s") = 10 "Velocity in the outlet";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";

//=============
// Variable Section

Real dWdm(unit = "J/kg") "Work done per kilogram";

//=============
// Equation Section

equation
dWdm = g * z + (v1^2 - v2^2)/2;
end Ex4_5;