//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.15 Page 162
//Title: Falling column of fluid from a faucet
//===================================================================

model Ex5_15

//=============
// Parameter Section

parameter Real v1(unit = "m/s") = 0.5 "Velocity at the exit";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real h(unit = "m") = 0.5 "Height below the faucet";
parameter Real d1(unit = "cm") = 2 "Diameter at the exit of the faucet";

//===============
// Library Section 

extends Modelica.Constants;

//=============
// Variable Section

Real v2(unit = "m/s") "Velocity at height below the faucet";
Real a(unit = "NA") "Ratio of area of the exit to the area at a height below the faucet";
Real d2(unit = "cm") "Diameter at a height below the faucet";

//=============
// Equation Section

equation 
v2 = (v1^2 + (2 * g * h))^0.5;
a =  v1 / v2;
d2 = d1 * (a)^0.5; 

end Ex5_15;