//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.3 Page 141
//Title: Flow out of Nozzle
//===================================================================

model Ex5_3

//=============
// Parameter Section 

parameter Real h(unit = "ft") = 30 "Height of the tank from the nozzle";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";

//=============
// Variable Section 

Real v(unit = "ft/s") "Fluid velocity in the nozzle";

//=============
// Equation Section

equation
v = (2* g* h)^(0.5); 
end Ex5_3;