//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.5 Page 145
//Title: Flow out of Nozzle with Gas in Tank
//===================================================================

model Ex5_5

//=============
// Parameter Section 

parameter Real h(unit = "ft") = 30 "Height of the tank from the nozzle";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real m_air(unit = "g/mol") = 29 "Molecular weight of air";
parameter Real m_co2(unit = "g/mol") = 44 "Molecular weight of CO2";


//=============
// Variable Section 

Real v(unit = "ft/s") "Fluid velocity in the nozzle";

//=============
// Equation Section

equation
v = ((2* g* h)*(1 -(m_air/m_co2)))^(0.5); 
end Ex5_5;
