//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.7 Page 148
//Title: Air flowing in Pitot Tube
//===================================================================

model Ex5_7

//=============
// Parameter Section 

parameter Real p(unit = "psi") = 0.05 "Pressure difference gauge";
parameter Real rho_air(unit = "lbm/ft3") = 0.075 "Density of air";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion of square inch to square foot";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion of lbm.ft to lbf.s2";

//=============
// Variable Section 

Real v(unit = "ft/s") "Air velocity";

//=============
// Equation Section 

equation
v = (2 * p * c1 * c2 / rho_air)^(0.5);

end Ex5_7;