//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.8 Page 149
//Title: Venturi Meter
//===================================================================

model Ex5_8

//=============
// Parameter Section 

parameter Real p_d(unit = "psi") = 1 "Pressure difference";
parameter Real rho_water(unit = "lbm/ft3") = 62.3 "Density of water";
parameter Real d_1(unit = "ft") = 1 "Diameter at point 1";
parameter Real d_2(unit = "ft") = 0.5 "Diameter at point 2";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion of square inch to square foot";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion of lbm.ft to lbf.s2";

//===============
// Library Section 

extends Modelica.Constants;

//=============
// Variable Section 

Real v(unit = "ft/s") "Fluid velocity";
Real q(unit = "ft3/s") "Volumetric flowrate of the fluid";

//=============
// Equation Section 

equation
v = ((2 * p_d * c1 * c2 / rho_water)/(1 - ((pi * d_2^2 / 4)^2)/((pi * d_1^2 / 4)^2)))^0.5;
q = v * pi * d_2^2 / 4;
end Ex5_8;