//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.22 Page 227
//Title: Flow around Submerged Objects
//===================================================================

model Ex6_22

//=============
// Parameter Section
parameter Real l(unit = "m") = 15 "Length of the wings from tip to tip";
parameter Real b(unit = "m") = 1.5 "Breadth of the wingspan";
parameter Real Cl(unit = "NA") = 0.8 "Lift coefficient in the level flight";
parameter Real Cd(unit = "NA") = 0.04 "Drag coefficient";
parameter Real v(unit = "km/h") = 150 "Velocity of the flight";
parameter Real rho(unit = "kg/m3") = 1.2 "Density of air";
parameter Real c1(unit = "m/km") = 1000 "Conversion factor";
parameter Real c2(unit = "s/h") = 3600 "Conversion factor";

//=============
// Variable Section

Real F_drag(unit = "N") "Drag force";
Real F_lift(unit = "N") "Maximum weight of loaded airplane or lift force";

//=============
// Equation Section

equation

F_drag = (l * b) * Cd * rho * v^2 * c1^2 / (2 * c2^2);
F_lift = (l * b) * Cl * rho * v^2 * c1^2 / (2 * c2^2);
end Ex6_22;