//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-8: One Dimensional, High Velocity Gas Flow
//Example: 8.1 Page 299
//Title: Speed of Sound
//===================================================================

model Ex8_1

//=============
// Parameter Section

parameter Real k_s(unit = "Pa") = 1.94 * 10^11 "Bulk Modulus of Steel";
parameter Real rho_s(unit = "kg/m3") = 7800 "Density of Steel";
parameter Real k_w(unit = "lbf/in2") = 3.14 * 10^5 "Bulk Modulus of Water";
parameter Real rho_w(unit = "lbm/ft3") = 62.3 "Density of Water";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion factor from square inch to square feet";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor from pound mass to pound force";

//=============
// Library Section

extends Modelica.Math;

//=============
// Variable Section

Real c_s(unit = "km/s") "Speed of sound in steel";
Real c_w(unit = "ft/s") "Speed of sound in water";

//=============
// Equation Section

equation
 
c_s = (sqrt(k_s / rho_s))/1000; //Converting from m to km
c_w = sqrt(k_w * c1 * c2 / rho_w);

end Ex8_1;