//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-8: One Dimensional, High Velocity Gas Flow
//Example: 8.5 Page 302
//Title: Steady Frictionless One Dimensional Flow of an Ideal Gas
//===================================================================

model Ex8_5
//=============
// Parameter Section

parameter Real M(unit = "NA") = 2 "Mach Number";
parameter Real k(unit = "NA") = 1.4 "Ratio of specific heats for diatomic gases";
parameter Real P_r(unit = "bar") = 2 "Pressure of air";
parameter Real rho_r(unit = "kg/m3") = 2.39 "Density of air";


//=============
// Variable Section

Real P_1(unit = "bar") "Pressure of gas at a particular point";
Real rho_1(unit = "kg/m3") "Density of gas at a particular point";

//=============
// Equation Section

equation
P_1 = P_r / (M^2 * ((k-1)/2) +1)^(k/(k-1));
rho_1 = rho_r / (M^2 * ((k-1)/2) +1)^(1/(k-1));
end Ex8_5;
