//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-1: Introduction
//Example: 1.4 Page 20
//Title: Conversion from mi/h to ft/s
//===================================================================

model Ex1_4

//=============
// Parameter Section 

parameter Real mph(unit = "mph") = 327 "Given value of speed in miles per hour";
parameter Real one_mile(unit = "ft/mi") = 5280 "One mile in terms of feet";
parameter Real one_hour(unit = "s/h") = 3600 "One hour in terms of seconds";

//=============
// Variable Section 

Real fps(unit = "fps") "Required value of speed in feet per second";


//=============
// Equation Section 

equation
fps = mph * one_mile / one_hour;  


end Ex1_4;
//===================================================================
