//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-10: Pumps, Compressors and Turbines
//Example: 10.3 Page 370
//Title: P.D Compressors
//===================================================================


model Ex10_3

//=============
// Parameter Section

parameter Real r(unit = "Btu/lbmol.R") = 1.987 "Universal gas constant";
parameter Real p2(unit = "atm") = 10 "Final pressure";
parameter Real p1(unit = "atm") = 1 "Initial pressure";
parameter Real t(unit = "°R") = 528 "Inlet temperature";
parameter Real k(unit = "NA") = 1.4 "k value for adiabatic conditions";

//=============
// Library Section

extends Modelica.Math;

//=============
// Variable Section
 
Real w1(unit = "Btu/lbmol") "Work per pound mole for isothermal compressor";
Real w2(unit = "Btu/lbmol") "Work per pound mole for adiabatic compressor"; 

//=============
// Equation Section

equation
w1 = r * t * log(p2/p1);
w2 = r * t * k * ((p2/p1)^((k-1)/k) - 1) / (k-1);
end Ex10_3;