//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-10: Pumps, Compressors and Turbines
//Example: 10.6 Page 378
//Title: NPSH
//===================================================================

model Ex10_6

//=============
// Parameter Section

parameter Real v1(unit = "ft/s") = 15.8 "Rotational velocity at the given point";
parameter Real v2(unit = "ft/s") = 9.56 "Radial velocity due to flow outward through the impeller";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real c1(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of water"; 

//=============
// Library Section

extends Modelica.Math;

//=============
// Variable Section

Real v_eye(unit = "ft/s") "Velocity at the eye of the impeller";
Real h(unit = "ft") "Pump head";

//=============
// Eqauation Section

equation
v_eye = sqrt( v1^2 + v2^2 );
h = (v_eye)^2 * c1 / (rho * g * 2);

//Value of "h" do not match with the book answer due to calculation error in the book.

end Ex10_6;