//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-11: Flow through Porous Media
//Example: 11.2 Page 403
//Title: Fluid Friction in Porous Media
//===================================================================

model Ex11_2

//=============
// Parameter Section

parameter Real V_s(unit = "ft/s") = 2 "Superficial velocity";
parameter Real E(unit  = "NA") = 0.33 "Porosity of the bed";
parameter Real rho(unit = "lbm/ft") = 62.3 "Density of water";
parameter Real D_p(unit = "in") = 0.03 "Diameter of particle";
parameter Real c1(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c2(unit = "in/ft") = 12 "Conversion factor";
parameter Real c3(unit = "in/ft") = 144 "Conversion factor";

//=============
// Variable Section

Real delP(unit = "psi/ft") "Required pressure gradient";

//=============
// Eqaution Section
 
equation

delP = ( 1.75 * rho * V_s^2 * (1-E) ) / ( (D_p/c2) * E^3 * c1 * c3);

end Ex11_2;