//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-13: Non Newtonian Fluid Flow in Circular Pipes
//Example: 13.1 Page 432
//Title: Power Law
//===================================================================

model Ex13_1

//=============
// Parameter Section

parameter Real V(unit = "ft/s") = 1 "Average velocity of the applesauce";
parameter Real D(unit = "ft") = 0.5 "Inner diameter of the pipe";
parameter Real c1(unit = "m/ft") = 0.3048 "Conversion factor";
parameter Real n(unit = "NA") = 0.41 "Power law constant from the table";
parameter Real k(unit = "kg/m.s(2-n)") = 0.66 "Power law constant from the table";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real Q(unit = "m3/s") "Volumetric flowrate of applesauce";
Real delp(unit = "Pa/m") "Pressure gradient required";

//=============
// Equation Section

equation
Q = (V * c1) * pi * (D * c1)^2 / 4;
delp = ( Q * 8 * (3 * n + 1) / (n * pi * (D * c1)^3))^n * (4 * k / (D * c1));
end Ex13_1;