//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-13: Non Newtonian Fluid Flow in Circular Pipes
//Example: 13.3 Page 437
//Title: Turbulent Steady Pipe Flow of Non-Newtonian Fluids
//===================================================================

model Ex13_3

//=============
// Parameter Section

parameter Real delp(unit = "Pa/m") = 61.3 "Pressure gradient maintained";
parameter Real D(unit = "m") = 0.152 "Diameter of the pipe";
parameter Real rho(unit = "kg/m3") = 1000 "Density of applesauce";
parameter Real v_avg(unit = "m/s") = 0.305 "Average velocity of the applesauce";
parameter Real n(unit = "NA") = 0.41 "Power law constant from the table";
parameter Real k(unit = "kg/m.s(2-n)") = 0.66 "Power law constant from the table";

//=============
// Variable Section

Real f(unit = "NA") "Fanning friction factor";
Real R(unit = "NA") "Reynolds Number";

//=============
// Equation Section

equation
f = (2 * delp * D) / (4 * rho * v_avg^2);
R = 8 * rho * v_avg^(2 - n) * D^n / (k * (2 * (3*n + 1) / n)^n);

end Ex13_3;