//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-13: Non Newtonian Fluid Flow in Circular Pipes
//Example: 13.4 Page 438
//Title: Turbulent Steady Pipe Flow of Non-Newtonian Fluids
//===================================================================

model Ex13_4

//=============
// Parameter Section

parameter Real D(unit = "m") = 0.152 "Diameter of the pipe";
parameter Real rho(unit = "kg/m3") = 1000 "Density of applesauce";
parameter Real v_avg(unit = "m/s") = 3.048 "Average velocity of the applesauce";
parameter Real n(unit = "NA") = 0.41 "Power law constant from the table";
parameter Real k(unit = "kg/m.s(2-n)") = 0.66 "Power law constant from the table";
parameter Real f(unit = "NA") = 0.004 "Friction factor determined from Fig. 13.3 for given R and n values";
parameter Real c1(unit = "Pa/kPa") = 1000 "Conversion factor";

//=============
// Variable Section

Real delP(unit = "kPa/m") "Pressure gradient maintained";
Real R(unit = "NA") "Reynolds Number";

//=============
// Equation Section

equation
R = 8 * rho * v_avg^(2 - n) * D^n / (k * (2 * (3*n + 1) / n)^n);
delP = 4 * f * rho  *(v_avg)^2 / (2 * D * c1);

end Ex13_4;