//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-19: Mixing
//Example: 19.2 Page 557
//Title: Power input from stir tank reactor
//===================================================================

model Ex19_2

//=============
// Parameter Section

parameter Real Di(unit = "ft") = 1 "Diameter of the impeller";
parameter Real N(unit = "s-1") = 4 "Rotations per minute";
parameter Real v(unit = "ft2/s") = 1.077 * 10^(-5) "Kinematic viscosity of the fluid";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of the fluid";
parameter Real c1(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c2(unit = "ft.lbf/hp.s") = 550 "Conversin factor";

//=============
// Variable Section

Real R(unit = "NA") "Reynold's number";
Real Po(unit = "hp") "Power number of the impeller";

//=============
// Equation Section

equation

R = ( N * Di^2 ) / v;
Po = 5 * rho * N^3 * Di^5 / (c1 * c2);

end Ex19_2;