//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-19: Mixing
//Example: 19.4 Page 569
//Title: Power input from stir tank reactor
//===================================================================

model Ex19_4

//=============
// Parameter Section

parameter Real Di(unit = "ft") = 1 "Diameter of the impeller";
parameter Real Dt(unit = "ft") = 3 "Diameter of the tank";
parameter Real N(unit = "s-1") = 4 "Rotations per minute";
parameter Real Ht(unit = "ft") = 3 "Height of the tank";

//=============
// Variable Section

Real t(unit = "s") "Time taken to blend the fluids";

//=============
// Equation Section

equation

t = (4.3 * ( Dt / Ht ) * ( Dt / Di )^2 ) / N;

end Ex19_4;