//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-19: Mixing
//Example: 19.7 Page 572
//Title: Mixing in Pipe Flow
//===================================================================

model Ex19_7

//=============
// Parameter Section

parameter Real f(unit = "NA") = 0.0039 "Friction facor";
parameter Real D(unit = "ft") = 0.665 "Diameter of the pipe";

//=============
// Variable Section

Real L(unit = "ft") "Length upto which dye is uniformly dispersed";

//=============
// Eqaution Section

equation

L = D * (0.56 / f^0.5);
end Ex19_7;