//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-19: Mixing
//Example: 19.8 Page 573
//Title: Mixing in Turbulent Free Jets
//===================================================================

model Ex19_8

//=============
// Parameter Section

parameter Real D(unit = "ft") = 1 "Diameter of the jet";
parameter Real x(unit = "ft") = 10 "Downstream distance";
parameter Real Vo(unit = "ft/s") = 40 "Inlet velocity";
parameter Real a(unit = "°") = 20 "Jet angle";
parameter Real R(unit = "ft") = 1 "Distance from the centerline";
parameter Real K(unit = "NA") = 6.2 "Constant in the equation";

//=============
// Library Section

extends Modelica.Math;
extends Modelica.Constants;

//=============
// Variable Section

Real Vc(unit = "ft/s") "Centerline velocity";
Real Vx(unit = "ft/s") "Velocity at a radial distance at x";
Real Dx(unit = "ft") "Jet diameter at distance x";
Real E(unit = "NA") "Entrainment ratio"; 

//=============
// Equation Section

equation

Vc = K * Vo * (D / x);
Vx = Vc  / ( 10 ^ ( 40 * ( R / x )^2 ) );
Dx = D * (1 + (x * sin(a * pi / 180) / D));   //Converting angle in degrees to radians
E = 0.62 * (x / D)^0.5;
 
end Ex19_8;