//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.10 Page 50
//Title: Pressure Vessels and Piping
//===================================================================

model Ex2_10

//=============
// Parameter Section

parameter Real D(unit = "ft") = 10 "Diameter of the cylinder";
parameter Real P(unit = "lbf/in2") = 250 "Working pressure of the system";
parameter Real S_t(unit = "lbf/in2") = 20000 "Design tensile stress";

//=============
// Variable Section

Real t(unit = "ft") "Required wall thickness";

//=============
// Equation Section

equation 
t = ( P * D ) / ( 2 * S_t ); 
end Ex2_10;