//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.13 Page 55
//Title: Pressure Measurement
//===================================================================

model Ex2_13

//=============
// Parameter Section

parameter Real P_a(unit = "lbm/ft.s2") = 0 "Gauge pressure at A";
parameter Real rho_w(unit = "lbm/ft3") = 62.3 "Density of water";
parameter Real rho_a(unit = "lbm/ft3") = 0.075 "Density of air";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real h_b(unit = "ft") = 3 "Height of fluid in one leg of the manometer";
parameter Real h_a(unit = "ft") = 0.5 "Height of fluid in leg of the manometer attached to the vessel";
parameter Real c1(unit  = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c2(unit  = "in2/ft2") = 144 "Conversion factor";

//=============
// Variable Section

Real P_b(unit = "lbm/ft.s2") "Gauge pressure at B";
Real P_c(unit = "lbm/ft.s2") "Gauge pressure at C";
Real P_d(unit = "lbf/in2") "Gauge pressure at D";

//=============
// Equation Section

equation

P_b = P_a + rho_w * g * h_b;
P_c = P_b - ( rho_w * g * h_a );
P_d = (P_c - ( rho_a * g * h_a )) / ( c1 * c2 );

end Ex2_13;