//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.17 Page 64
//Title: Pressure in Accelerated Rigid Body Motions
//===================================================================

model Ex2_17

//=============
// Parameter Section

parameter Real rho_w(unit = "kg/m3") = 998.2 "Density of water";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real h(unit = "m") = 5 "Height of the open tank";
parameter Real a_u(unit = "m/s2") = 5 "Upward acceleration of the elevator";
parameter Real a_d(unit = "m/s2") = -5 "Dowward acceleration of the elaevator";

//=============
// Variable Section

Real P_bottom_a(unit = "Pa") "Gauge pressure at the bottom when elevator is still";
Real P_bottom_b(unit = "Pa") "Gauge pressure at the bottom when elevator is moving up";
Real P_bottom_c(unit = "Pa") "Gauge pressure at the bottom when elevator is moving down";

//=============
// Equation Section

equation

P_bottom_a = rho_w * g * h;
P_bottom_b = rho_w * h * ( g + a_u );
P_bottom_c = rho_w * h * ( g + a_d );

end Ex2_17;