//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-2: Fluid Statics
//Example: 2.6 Page 45
//Title: Pressure Forces on Surfaces
//===================================================================

model Ex2_6

//=============
// Parameter Section

parameter Real D(unit = "ft") = 120 "Diameter of the tank";
parameter Real P(unit = "lbf/in") = 14.7 "Atmospheric pressure above the tank surface";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion factor";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real F(unit = "lbf") "Force exerted by the atmosphere on the roof";

//=============
// Equation Section

equation
F = P * pi * c1 * (D)^2 / 4;

end Ex2_6;