//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-3: The Balance Equation and the Mass Balance
//Example: 3.6 Page 91
//Title: Velocity Distributors
//===================================================================

model Ex3_6

//=============
// Parameter Section 

parameter Real v_1(unit = "m/s") = 2 "Velocity of water at point 1";
parameter Real rho_1(unit = "kg/m3") = 998.2 "Density of water at point 1";
parameter Real d_1(unit = "m") = 0.25 "Diameter of the pipe at point 1";
parameter Real d_2(unit = "m") = 0.125 "Diameter of the pipe at point 2";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section 

Real m(unit = "kg/s") "Mass flowrate of the water";
Real Q(unit = "m3/s") "Volumetric flowrate of the water";
Real v_2(unit = "m/s") "Velocity of water at point 2";

//=============
// Equation Section

equation
m = rho_1 * v_1 * (pi/4) * d_1^2;
Q = v_1 * (pi/4) * d_1^2;
v_2 = v_1 * ( (pi * d_1^2 / 4) / (pi * d_2^2 / 4) );
end Ex3_6;