//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-3: The Balance Equation and the Mass Balance
//Example: 3.7 Page 92
//Title: Unsteady State Mass Balances
//===================================================================

model Ex3_7

//=============
// Parameter Section 

parameter Real V_sys(unit = "ft3") = 10 "Volume of the furnace";
parameter Real Q_out(unit = "ft3/min") = 1 "Volumetric flowrate at the inlet of the pump";
parameter Real P_int(unit = "atm") = 1 "Initial pressure maintained";
parameter Real P_fin(unit = "atm") = 0.0001 "Final pressure attained";

//=============
// Library Section

extends Modelica.Math;

//=============
// Variable Section

Real delt(unit = "min") "Time taken for the pressure to fall";

//=============
// Equation Section  
 
equation
delt = (V_sys / Q_out) * log( P_int / P_fin ); 
end Ex3_7;